/*
  createProcesses.c
  Calls fork N times, printing the return values each time.

  Why the wait?  
  Try taking it out.  Before the child gets to print the parent's id,
  sometimes the parent will have died.
 */

#include <stdio.h>       // printf
#include <unistd.h>      // fork
#include <sys/wait.h>    // wait

const int N = 3;

int main() {
    printf("Original.  pid: %d\n", getpid());
    for (int i = 0; i < N; ++i) {
	if (fork() == 0) // Child
	    printf("Child.  pid: %d; ppid: %d\n", getpid(), getppid());
	else wait(NULL); // Parent
    }    
}
